<?xml version="1.0" encoding="UTF-8"?>
<assistantconfig version="3.2.0">
  <profile>
    <property name="name">QCad</property>
    <property name="title">Help</property>
    <property name="applicationicon">img/qcadicon.png</property>
    <property name="startpage">index.html</property>
    <property name="assistantdocs">.</property>
  </profile>
  <DCF icon="img/qcadicon.png" ref="index.html" title="QCad User Reference Manual">
    <section ref="chapter01.html" title="1. Abstract"/>
    <section ref="chapter02.html" title="2. License">
      <section ref="chapter02.html#1" title="2.1. Copyright"/>
      <section ref="chapter02.html#2" title="2.2. The GNU General Public License">
        <keyword ref="chapter02.html#GNU">GNU</keyword>
        <keyword ref="chapter02.html#GPL">GPL</keyword>
        <keyword ref="chapter02.html#license">license</keyword>
        <keyword ref="chapter02.html#open source">open source</keyword>
      </section>
      <section ref="chapter02.html#3" title="2.3. Trademarks"/>
    </section>
    <section ref="chapter03.html" title="3. Preface">
      <section ref="chapter03.html#1" title="3.1. CAD for the Uninitiated">
        <keyword ref="chapter03.html#cad">cad</keyword>
        <keyword ref="chapter03.html#computer-aided design">computer-aided design</keyword>
      </section>
      <section ref="chapter03.html#2" title="3.2. How Can I Get QCad"/>
      <section ref="chapter03.html#3" title="3.3. Is QCad for me?">
        <keyword ref="chapter03.html#2d">2d</keyword>
        <keyword ref="chapter03.html#3d">3d</keyword>
        <keyword ref="chapter03.html#platforms">platforms</keyword>
      </section>
      <section ref="chapter03.html#4" title="3.4. QCad and Qt">
        <keyword ref="chapter03.html#qt">qt</keyword>
        <keyword ref="chapter03.html#trolltech">trolltech</keyword>
      </section>
      <section ref="chapter03.html#5" title="3.5. Scope of This Manual"/>
      <section ref="chapter03.html#6" title="3.6. Who Is Behind QCad"/>
    </section>
    <section ref="chapter04.html" title="4. Basic CAD Concepts">
      <section ref="chapter04.html#1" title="4.1. Entities">
        <keyword ref="chapter04.html#entity">entity</keyword>
        <keyword ref="chapter04.html#graphic object">graphic object</keyword>
      </section>
      <section ref="chapter04.html#2" title="4.2. Attributes">
        <keyword ref="chapter04.html#Attribute">Attribute</keyword>
      </section>
      <section ref="chapter04.html#3" title="4.3. Layers">
        <keyword ref="chapter04.html#layer">layer</keyword>
      </section>
      <section ref="chapter04.html#4" title="4.4. Blocks">
        <keyword ref="chapter04.html#block">block</keyword>
        <keyword ref="chapter04.html#insert">insert</keyword>
        <keyword ref="chapter04.html#group of entities">group of entities</keyword>
      </section>
      <section ref="chapter04.html#5" title="4.5. Drafting in CAD"/>
      <section ref="chapter04.html#6" title="4.6. Coordinate Systems">
        <keyword ref="chapter04.html#coordinate systems">coordinate systems</keyword>
        <keyword ref="chapter04.html#origin">origin</keyword>
        <keyword ref="chapter04.html#zero">zero</keyword>
        <keyword ref="chapter04.html#absolute zero">absolute zero</keyword>
        <keyword ref="chapter04.html#cartesian coordinates">cartesian coordinates</keyword>
        <keyword ref="chapter04.html#x-ordinate">x-ordinate</keyword>
        <keyword ref="chapter04.html#y-ordinate">y-ordinate</keyword>
        <keyword ref="chapter04.html#polar coordinates">polar coordinates</keyword>
        <keyword ref="chapter04.html#angle">angle</keyword>
      </section>
      <section ref="chapter04.html#7" title="4.7. Object and Grid Snapping">
        <keyword ref="chapter04.html#object snapping">object snapping</keyword>
        <keyword ref="chapter04.html#grid snapping">grid snapping</keyword>
        <keyword ref="chapter04.html#snapping">snapping</keyword>
      </section>
      <section ref="chapter04.html#8" title="4.8. Basic Editing">
        <keyword ref="chapter04.html#entity creation">entity creation</keyword>
        <keyword ref="chapter04.html#draw">draw</keyword>
        <keyword ref="chapter04.html#create">create</keyword>
        <keyword ref="chapter04.html#select entities">select entities</keyword>
        <keyword ref="chapter04.html#entity selection">entity selection</keyword>
        <keyword ref="chapter04.html#deletion">deletion</keyword>
        <keyword ref="chapter04.html#delete entities">delete entities</keyword>
        <keyword ref="chapter04.html#modifications">modifications</keyword>
        <keyword ref="chapter04.html#transformations">transformations</keyword>
      </section>
      <section ref="chapter04.html#9" title="4.9. Viewing in CAD">
        <keyword ref="chapter04.html#viewing">viewing</keyword>
        <keyword ref="chapter04.html#drawing scale">drawing scale</keyword>
        <keyword ref="chapter04.html#sheet size">sheet size</keyword>
        <keyword ref="chapter04.html#visible area">visible area</keyword>
        <keyword ref="chapter04.html#zooming">zooming</keyword>
        <keyword ref="chapter04.html#display">display</keyword>
      </section>
    </section>
    <section ref="chapter05.html" title="5. Starting a QCad Session">
      <section ref="chapter05.html#1" title="5.1. Linux / Unix Operating Systems"/>
      <section ref="chapter05.html#2" title="5.2. Mac OS X Operating System"/>
      <section ref="chapter05.html#3" title="5.3. Windows Operating Systems"/>
    </section>
    <section ref="chapter06.html" title="6. The QCad User Interface">
      <section ref="chapter06.html#1" title="6.1. Main Application Window">
        <keyword ref="chapter06.html#gui">gui</keyword>
        <keyword ref="chapter06.html#user interface">user interface</keyword>
        <keyword ref="chapter06.html#application window">application window</keyword>
        <keyword ref="chapter06.html#drawing area">drawing area</keyword>
        <keyword ref="chapter06.html#main application window">main application window</keyword>
      </section>
      <section ref="chapter06.html#2" title="6.2. Menu and CAD Toolbar">
        <keyword ref="chapter06.html#menu">menu</keyword>
        <keyword ref="chapter06.html#cad toolbar">cad toolbar</keyword>
        <keyword ref="chapter06.html#toolbar">toolbar</keyword>
      </section>
      <section ref="chapter06.html#3" title="6.3. Layer List and Block List">
        <keyword ref="chapter06.html#layer list">layer list</keyword>
        <keyword ref="chapter06.html#block list">block list</keyword>
        <keyword ref="chapter06.html#view - views - layer list">view - views - layer list</keyword>
        <keyword ref="chapter06.html#view - views - block list">view - views - block list</keyword>
      </section>
      <section ref="chapter06.html#4" title="6.4. Status Bar">
        <keyword ref="chapter06.html#status bar">status bar</keyword>
        <keyword ref="chapter06.html#view - views - statusbar">view - views - statusbar</keyword>
      </section>
      <section ref="chapter06.html#5" title="6.5. Command Widget">
        <keyword ref="chapter06.html#command widget">command widget</keyword>
        <keyword ref="chapter06.html#view - views - command widget">view - views - command widget</keyword>
      </section>
      <section ref="chapter06.html#6" title="6.6. Option Toolbar">
        <keyword ref="chapter06.html#option toolbar">option toolbar</keyword>
        <keyword ref="chapter06.html#view - views - option toolbar">view - views - option toolbar</keyword>
      </section>
      <section ref="chapter06.html#7" title="6.7. Executing Commands"/>
      <section ref="chapter06.html#8" title="6.8. Modes"/>
    </section>
    <section ref="chapter07.html" title="7. The Command Line">
      <section ref="chapter07.html#1" title="7.1. Using the Commandline">
        <keyword ref="chapter07.html#command line">command line</keyword>
        <keyword ref="chapter07.html#commands">commands</keyword>
        <keyword ref="chapter07.html#view - command line">view - command line</keyword>
      </section>
      <section ref="chapter07.html#2" title="7.2. A Word About Keyboard Focus"/>
    </section>
    <section ref="chapter08.html" title="8. File Handling">
      <section ref="chapter08.html#1" title="8.1. Creating New Drawings">
        <keyword ref="chapter08.html#file">file</keyword>
        <keyword ref="chapter08.html#new drawing">new drawing</keyword>
        <keyword ref="chapter08.html#file - new">file - new</keyword>
        <keyword ref="chapter08.html#create drawing">create drawing</keyword>
      </section>
      <section ref="chapter08.html#2" title="8.2. Opening Drawings">
        <keyword ref="chapter08.html#file">file</keyword>
        <keyword ref="chapter08.html#open drawing">open drawing</keyword>
        <keyword ref="chapter08.html#file - open">file - open</keyword>
      </section>
      <section ref="chapter08.html#3" title="8.3. Saving Drawings">
        <keyword ref="chapter08.html#file">file</keyword>
        <keyword ref="chapter08.html#save file">save file</keyword>
        <keyword ref="chapter08.html#file - save">file - save</keyword>
        <keyword ref="chapter08.html#file - save as">file - save as</keyword>
      </section>
      <section ref="chapter08.html#4" title="8.4. Exporting Drawings as Bitmaps">
        <keyword ref="chapter08.html#export">export</keyword>
        <keyword ref="chapter08.html#bitmap">bitmap</keyword>
        <keyword ref="chapter08.html#raster graphic">raster graphic</keyword>
        <keyword ref="chapter08.html#png">png</keyword>
        <keyword ref="chapter08.html#gif">gif</keyword>
        <keyword ref="chapter08.html#xpm">xpm</keyword>
        <keyword ref="chapter08.html#xbm">xbm</keyword>
        <keyword ref="chapter08.html#jpeg">jpeg</keyword>
      </section>
      <section ref="chapter08.html#5" title="8.5. Closing Drawings">
        <keyword ref="chapter08.html#file">file</keyword>
        <keyword ref="chapter08.html#close file">close file</keyword>
        <keyword ref="chapter08.html#file - close">file - close</keyword>
      </section>
    </section>
    <section ref="chapter09.html" title="9. Printing">
      <section ref="chapter09.html#1" title="9.1. Print Preview">
        <keyword ref="chapter09.html#print">print</keyword>
        <keyword ref="chapter09.html#print preview">print preview</keyword>
        <keyword ref="chapter09.html#preview">preview</keyword>
        <keyword ref="chapter09.html#file - print preview">file - print preview</keyword>
      </section>
      <section ref="chapter09.html#2" title="9.2. Print">
        <keyword ref="chapter09.html#print">print</keyword>
        <keyword ref="chapter09.html#file - print">file - print</keyword>
        <keyword ref="chapter09.html#ps">ps</keyword>
        <keyword ref="chapter09.html#pdf">pdf</keyword>
      </section>
    </section>
    <section ref="chapter10.html" title="10. Basic Editing Commands">
      <section ref="chapter10.html#1" title="10.1. Undo">
        <keyword ref="chapter10.html#undo">undo</keyword>
        <keyword ref="chapter10.html#edit - undo">edit - undo</keyword>
      </section>
      <section ref="chapter10.html#2" title="10.2. Redo">
        <keyword ref="chapter10.html#redo">redo</keyword>
        <keyword ref="chapter10.html#edit - redo">edit - redo</keyword>
      </section>
      <section ref="chapter10.html#3" title="10.3. Copy">
        <keyword ref="chapter10.html#copy">copy</keyword>
        <keyword ref="chapter10.html#edit - copy">edit - copy</keyword>
      </section>
      <section ref="chapter10.html#4" title="10.4. Cut">
        <keyword ref="chapter10.html#cut">cut</keyword>
        <keyword ref="chapter10.html#edit - cut">edit - cut</keyword>
      </section>
      <section ref="chapter10.html#5" title="10.5. Paste">
        <keyword ref="chapter10.html#paste">paste</keyword>
        <keyword ref="chapter10.html#edit - paste">edit - paste</keyword>
      </section>
    </section>
    <section ref="chapter11.html" title="11. Viewing">
      <section ref="chapter11.html#1" title="11.1. Scrolling">
        <keyword ref="chapter11.html#scrolling">scrolling</keyword>
        <keyword ref="chapter11.html#scrollbars">scrollbars</keyword>
        <keyword ref="chapter11.html#panning">panning</keyword>
      </section>
      <section ref="chapter11.html#2" title="11.2. Toggle Grid">
        <keyword ref="chapter11.html#grid">grid</keyword>
        <keyword ref="chapter11.html#toggle grid">toggle grid</keyword>
        <keyword ref="chapter11.html#view - grid">view - grid</keyword>
      </section>
      <section ref="chapter11.html#3" title="11.3. Toggle Draft Mode">
        <keyword ref="chapter11.html#draft">draft</keyword>
        <keyword ref="chapter11.html#toggle draft mode">toggle draft mode</keyword>
        <keyword ref="chapter11.html#view - draft">view - draft</keyword>
      </section>
      <section ref="chapter11.html#4" title="11.4. Redrawing">
        <keyword ref="chapter11.html#view">view</keyword>
        <keyword ref="chapter11.html#redraw">redraw</keyword>
        <keyword ref="chapter11.html#regen">regen</keyword>
      </section>
      <section ref="chapter11.html#5" title="11.5. Zooming In / Out">
        <keyword ref="chapter11.html#zoom in">zoom in</keyword>
        <keyword ref="chapter11.html#zoom out">zoom out</keyword>
        <keyword ref="chapter11.html#zoom">zoom</keyword>
      </section>
      <section ref="chapter11.html#6" title="11.6. Auto Zoom">
        <keyword ref="chapter11.html#zoom auto">zoom auto</keyword>
        <keyword ref="chapter11.html#auto zoom">auto zoom</keyword>
      </section>
      <section ref="chapter11.html#7" title="11.7. Previous View">
        <keyword ref="chapter11.html#zoom previous">zoom previous</keyword>
        <keyword ref="chapter11.html#previous">previous</keyword>
        <keyword ref="chapter11.html#view - previous">view - previous</keyword>
      </section>
      <section ref="chapter11.html#8" title="11.8. Window Zoom">
        <keyword ref="chapter11.html#zoom window">zoom window</keyword>
        <keyword ref="chapter11.html#window zoom">window zoom</keyword>
      </section>
      <section ref="chapter11.html#9" title="11.9. Panning">
        <keyword ref="chapter11.html#zoom pan">zoom pan</keyword>
        <keyword ref="chapter11.html#panning">panning</keyword>
        <keyword ref="chapter11.html#view - pan zoom">view - pan zoom</keyword>
      </section>
    </section>
    <section ref="chapter12.html" title="12. Layers">
      <section ref="chapter12.html#1" title="12.1. Changing the Visibility of a Layer"/>
      <section ref="chapter12.html#2" title="12.2. Changing the Visibility of all Layers"/>
      <section ref="chapter12.html#3" title="12.3. Adding New Layers"/>
      <section ref="chapter12.html#4" title="12.4. Deleting Layers"/>
      <section ref="chapter12.html#5" title="12.5. Editing Layer Attributes"/>
    </section>
    <section ref="chapter13.html" title="13. Blocks">
      <section ref="chapter13.html#1" title="13.1. Changing the Visibility of a Block"/>
      <section ref="chapter13.html#2" title="13.2. Changing the Visibility of all Blocks"/>
      <section ref="chapter13.html#3" title="13.3. Adding new Blocks"/>
      <section ref="chapter13.html#4" title="13.4. Removing Blocks"/>
      <section ref="chapter13.html#5" title="13.5. Renaming Blocks"/>
      <section ref="chapter13.html#6" title="13.6. Editing Blocks"/>
      <section ref="chapter13.html#7" title="13.7. Inserting Blocks"/>
      <section ref="chapter13.html#8" title="13.8. Creating Blocks from Existing Entities"/>
    </section>
    <section ref="chapter14.html" title="14. Object Snap">
      <section ref="chapter14.html#1" title="14.1. Free Positioning">
        <keyword ref="chapter14.html#free positioning">free positioning</keyword>
        <keyword ref="chapter14.html#snap - free">snap - free</keyword>
      </section>
      <section ref="chapter14.html#2" title="14.2. Snap to Grid">
        <keyword ref="chapter14.html#grid">grid</keyword>
        <keyword ref="chapter14.html#snap - grid">snap - grid</keyword>
      </section>
      <section ref="chapter14.html#3" title="14.3. Snap to Endpoints">
        <keyword ref="chapter14.html#endpoints">endpoints</keyword>
        <keyword ref="chapter14.html#snap - endpoints">snap - endpoints</keyword>
      </section>
      <section ref="chapter14.html#4" title="14.4. Snap to Points on Entities">
        <keyword ref="chapter14.html#on entity">on entity</keyword>
        <keyword ref="chapter14.html#snap - on entity">snap - on entity</keyword>
      </section>
      <section ref="chapter14.html#5" title="14.5. Snap to Centers">
        <keyword ref="chapter14.html#centers">centers</keyword>
        <keyword ref="chapter14.html#snap - centers">snap - centers</keyword>
      </section>
      <section ref="chapter14.html#6" title="14.6. Snap to Middle Points">
        <keyword ref="chapter14.html#middles">middles</keyword>
        <keyword ref="chapter14.html#snap - middle">snap - middle</keyword>
      </section>
      <section ref="chapter14.html#7" title="14.7. Snap to Distance Points">
        <keyword ref="chapter14.html#distance from endpoint">distance from endpoint</keyword>
        <keyword ref="chapter14.html#snap - distance from endpoint">snap - distance from endpoint</keyword>
      </section>
      <section ref="chapter14.html#8" title="14.8. Snap to Intersections">
        <keyword ref="chapter14.html#intersection">intersection</keyword>
        <keyword ref="chapter14.html#snap - intersection">snap - intersection</keyword>
      </section>
      <section ref="chapter14.html#9" title="14.9. Snap to Intersections Manually">
        <keyword ref="chapter14.html#intersection">intersection</keyword>
        <keyword ref="chapter14.html#snap - intersection manually">snap - intersection manually</keyword>
      </section>
      <section ref="chapter14.html#10" title="14.10. Snap Restrictions">
        <keyword ref="chapter14.html#restrict nothing">restrict nothing</keyword>
        <keyword ref="chapter14.html#snap - restrict nothing">snap - restrict nothing</keyword>
        <keyword ref="chapter14.html#restrict orthogonally">restrict orthogonally</keyword>
        <keyword ref="chapter14.html#snap - restrict&#10;    orthogonally">snap - restrict
    orthogonally</keyword>
        <keyword ref="chapter14.html#restrict horizontally">restrict horizontally</keyword>
        <keyword ref="chapter14.html#snap - restrict&#10;    horizontally">snap - restrict
    horizontally</keyword>
        <keyword ref="chapter14.html#restrict vertically">restrict vertically</keyword>
        <keyword ref="chapter14.html#snap - restrict vertically">snap - restrict vertically</keyword>
      </section>
      <section ref="chapter14.html#11" title="14.11. Relative Zero Point">
        <keyword ref="chapter14.html#move relative zero">move relative zero</keyword>
        <keyword ref="chapter14.html#relative zero">relative zero</keyword>
        <keyword ref="chapter14.html#set relative zero">set relative zero</keyword>
        <keyword ref="chapter14.html#snap - relative zero">snap - relative zero</keyword>
        <keyword ref="chapter14.html#lock relative zero">lock relative zero</keyword>
        <keyword ref="chapter14.html#relative zero">relative zero</keyword>
        <keyword ref="chapter14.html#unlock relative zero">unlock relative zero</keyword>
        <keyword ref="chapter14.html#snap -&#10;    lock relative zero">snap -
    lock relative zero</keyword>
      </section>
    </section>
    <section ref="chapter15.html" title="15. Construction"/>
    <section ref="chapter16.html" title="16. Points">
      <section ref="chapter16.html#1" title="16.1. Single Points">
        <keyword ref="chapter16.html#Point">Point</keyword>
      </section>
    </section>
    <section ref="chapter17.html" title="17. Lines">
      <section ref="chapter17.html#1" title="17.1. Sequence of Lines">
        <keyword ref="chapter17.html#sequence of lines">sequence of lines</keyword>
        <keyword ref="chapter17.html#line">line</keyword>
        <keyword ref="chapter17.html#line - sequence">line - sequence</keyword>
      </section>
      <section ref="chapter17.html#2" title="17.2. Lines with Given Angle">
        <keyword ref="chapter17.html#line">line</keyword>
        <keyword ref="chapter17.html#angle">angle</keyword>
        <keyword ref="chapter17.html#line - angle">line - angle</keyword>
      </section>
      <section ref="chapter17.html#3" title="17.3. Horizontal / Vertical Lines">
        <keyword ref="chapter17.html#line">line</keyword>
        <keyword ref="chapter17.html#horizontal">horizontal</keyword>
        <keyword ref="chapter17.html#vertical">vertical</keyword>
        <keyword ref="chapter17.html#line - horizontal">line - horizontal</keyword>
        <keyword ref="chapter17.html#line -&#10;    vertical">line -
    vertical</keyword>
      </section>
      <section ref="chapter17.html#4" title="17.4. Rectangles">
        <keyword ref="chapter17.html#rectangle">rectangle</keyword>
        <keyword ref="chapter17.html#line - rectangle">line - rectangle</keyword>
      </section>
      <section ref="chapter17.html#5" title="17.5. Bisectors">
        <keyword ref="chapter17.html#bisector">bisector</keyword>
        <keyword ref="chapter17.html#angle bisector">angle bisector</keyword>
        <keyword ref="chapter17.html#line - bisector">line - bisector</keyword>
      </section>
      <section ref="chapter17.html#6" title="17.6. Parallels">
        <keyword ref="chapter17.html#parallel">parallel</keyword>
        <keyword ref="chapter17.html#parallel line">parallel line</keyword>
        <keyword ref="chapter17.html#line - parallel">line - parallel</keyword>
      </section>
      <section ref="chapter17.html#7" title="17.7. Parallels through Point">
        <keyword ref="chapter17.html#parallel">parallel</keyword>
        <keyword ref="chapter17.html#parallel line">parallel line</keyword>
        <keyword ref="chapter17.html#line - parallel">line - parallel</keyword>
      </section>
      <section ref="chapter17.html#8" title="17.8. Tangents from Point to Arc / Circle">
        <keyword ref="chapter17.html#tangent">tangent</keyword>
        <keyword ref="chapter17.html#line - tangent">line - tangent</keyword>
      </section>
      <section ref="chapter17.html#9" title="17.9. Tangents from Arc to Arc / Circle to Circle">
        <keyword ref="chapter17.html#tangent">tangent</keyword>
        <keyword ref="chapter17.html#line - tangent">line - tangent</keyword>
      </section>
      <section ref="chapter17.html#10" title="17.10. Lines Orthogonal to Other Entities">
        <keyword ref="chapter17.html#orthogonal">orthogonal</keyword>
        <keyword ref="chapter17.html#line - orthogonal">line - orthogonal</keyword>
      </section>
      <section ref="chapter17.html#11" title="17.11. Line with Relative Angle to Other Entities">
        <keyword ref="chapter17.html#relative angle">relative angle</keyword>
        <keyword ref="chapter17.html#line - relative angle">line - relative angle</keyword>
      </section>
      <section ref="chapter17.html#12" title="17.12. Polygon with Center and Corner">
        <keyword ref="chapter17.html#polygon">polygon</keyword>
        <keyword ref="chapter17.html#line - polygon">line - polygon</keyword>
      </section>
      <section ref="chapter17.html#13" title="17.13. Polygon with Two Corners">
        <keyword ref="chapter17.html#polygon">polygon</keyword>
        <keyword ref="chapter17.html#line - polygon">line - polygon</keyword>
      </section>
      <section ref="chapter17.html#14" title="17.14. Freehand Line">
        <keyword ref="chapter17.html#freehand line">freehand line</keyword>
        <keyword ref="chapter17.html#line - freehand">line - freehand</keyword>
      </section>
    </section>
    <section ref="chapter18.html" title="18. Arcs">
      <section ref="chapter18.html#1" title="18.1. Arc with Center, Radius and Angles">
        <keyword ref="chapter18.html#arc">arc</keyword>
        <keyword ref="chapter18.html#center">center</keyword>
        <keyword ref="chapter18.html#angle">angle</keyword>
        <keyword ref="chapter18.html#arc - center point angles">arc - center point angles</keyword>
      </section>
      <section ref="chapter18.html#2" title="18.2. Arc with 3 Points">
        <keyword ref="chapter18.html#arc">arc</keyword>
        <keyword ref="chapter18.html#3 points arc">3 points arc</keyword>
        <keyword ref="chapter18.html#three points arc">three points arc</keyword>
        <keyword ref="chapter18.html#arc - 3&#10;    points">arc - 3
    points</keyword>
      </section>
      <section ref="chapter18.html#3" title="18.3. Concentric Arc">
        <keyword ref="chapter18.html#parallel">parallel</keyword>
        <keyword ref="chapter18.html#concentric arc">concentric arc</keyword>
        <keyword ref="chapter18.html#arc - concentric">arc - concentric</keyword>
      </section>
    </section>
    <section ref="chapter19.html" title="19. Circles">
      <section ref="chapter19.html#1" title="19.1. Circle with Center and Point">
        <keyword ref="chapter19.html#circle">circle</keyword>
        <keyword ref="chapter19.html#center">center</keyword>
        <keyword ref="chapter19.html#circle - center point">circle - center point</keyword>
      </section>
      <section ref="chapter19.html#2" title="19.2. Circle with Center and Radius">
        <keyword ref="chapter19.html#circle">circle</keyword>
        <keyword ref="chapter19.html#center">center</keyword>
        <keyword ref="chapter19.html#radius">radius</keyword>
        <keyword ref="chapter19.html#circle - center radius">circle - center radius</keyword>
      </section>
      <section ref="chapter19.html#3" title="19.3. Circle with 2 Points">
        <keyword ref="chapter19.html#circle">circle</keyword>
        <keyword ref="chapter19.html#2 points circle">2 points circle</keyword>
        <keyword ref="chapter19.html#two points circle">two points circle</keyword>
        <keyword ref="chapter19.html#circle - 2&#10;    points">circle - 2
    points</keyword>
      </section>
      <section ref="chapter19.html#4" title="19.4. Circle with 3 Points">
        <keyword ref="chapter19.html#circle">circle</keyword>
        <keyword ref="chapter19.html#3 points circle">3 points circle</keyword>
        <keyword ref="chapter19.html#three points circle">three points circle</keyword>
        <keyword ref="chapter19.html#circle - 3&#10;    points">circle - 3
    points</keyword>
      </section>
      <section ref="chapter19.html#5" title="19.5. Concentric Circle">
        <keyword ref="chapter19.html#concentric circle">concentric circle</keyword>
        <keyword ref="chapter19.html#circle - parallel">circle - parallel</keyword>
        <keyword ref="chapter19.html#circle -&#10;    concentric">circle -
    concentric</keyword>
      </section>
    </section>
    <section ref="chapter20.html" title="20. Ellipses">
      <section ref="chapter20.html#1" title="20.1. Full Ellipses">
        <keyword ref="chapter20.html#ellipse">ellipse</keyword>
      </section>
      <section ref="chapter20.html#2" title="20.2. Ellipse Arcs">
        <keyword ref="chapter20.html#ellipse arc">ellipse arc</keyword>
      </section>
    </section>
    <section ref="chapter21.html" title="21. Polylines">
      <section ref="chapter21.html#1" title="21.1. Creating a Polyline">
        <keyword ref="chapter21.html#polyline - create">polyline - create</keyword>
      </section>
      <section ref="chapter21.html#2" title="21.2. Adding Nodes to Polylines">
        <keyword ref="chapter21.html#polyline - add node to polyline">polyline - add node to polyline</keyword>
      </section>
      <section ref="chapter21.html#3" title="21.3. Appending Nodes to Polylines">
        <keyword ref="chapter21.html#polyline - add node to polyline">polyline - add node to polyline</keyword>
      </section>
      <section ref="chapter21.html#4" title="21.4. Deleting Nodes from Polylines">
        <keyword ref="chapter21.html#Polyline - Delete Polyline node">Polyline - Delete Polyline node</keyword>
      </section>
      <section ref="chapter21.html#5" title="21.5. Deleting Segments Between Two Nodes">
        <keyword ref="chapter21.html#Polyline - Delete between two nodes">Polyline - Delete between two nodes</keyword>
      </section>
      <section ref="chapter21.html#6" title="21.6. Trimming Polyline Segments">
        <keyword ref="chapter21.html#Polyline - Trim Segments">Polyline - Trim Segments</keyword>
      </section>
      <section ref="chapter21.html#7" title="21.7. Creating Equidistant Polylines">
        <keyword ref="chapter21.html#polyline - equidistant">polyline - equidistant</keyword>
        <keyword ref="chapter21.html#equidistant">equidistant</keyword>
      </section>
      <section ref="chapter21.html#8" title="21.8. Creating a Polyline from Existing Segments">
        <keyword ref="chapter21.html#polyline - from segments">polyline - from segments</keyword>
        <keyword ref="chapter21.html#segments">segments</keyword>
      </section>
    </section>
    <section ref="chapter22.html" title="22. Splines"/>
    <section ref="chapter23.html" title="23. Texts">
      <section ref="chapter23.html#1" title="23.1. Advanced"/>
    </section>
    <section ref="chapter24.html" title="24. Dimensions">
      <section ref="chapter24.html#1" title="24.1. Aligned Dimensions">
        <keyword ref="chapter24.html#aligned dimension">aligned dimension</keyword>
        <keyword ref="chapter24.html#dimension - aligned">dimension - aligned</keyword>
      </section>
      <section ref="chapter24.html#2" title="24.2. Linear Dimensions">
        <keyword ref="chapter24.html#linear dimension">linear dimension</keyword>
        <keyword ref="chapter24.html#dimension - linear">dimension - linear</keyword>
      </section>
      <section ref="chapter24.html#3" title="24.3. Horizontal / Vertical Dimensions">
        <keyword ref="chapter24.html#horizontal dimension">horizontal dimension</keyword>
        <keyword ref="chapter24.html#vertical dimension">vertical dimension</keyword>
        <keyword ref="chapter24.html#dimension - horizontal">dimension - horizontal</keyword>
        <keyword ref="chapter24.html#dimension - vertical">dimension - vertical</keyword>
      </section>
      <section ref="chapter24.html#4" title="24.4. Radial Dimensions">
        <keyword ref="chapter24.html#radial dimension">radial dimension</keyword>
        <keyword ref="chapter24.html#dimension - radial">dimension - radial</keyword>
      </section>
      <section ref="chapter24.html#5" title="24.5. Diametric Dimensions">
        <keyword ref="chapter24.html#diametric dimension">diametric dimension</keyword>
        <keyword ref="chapter24.html#dimension - diametric">dimension - diametric</keyword>
      </section>
      <section ref="chapter24.html#6" title="24.6. Angular Dimensions">
        <keyword ref="chapter24.html#angular dimension">angular dimension</keyword>
        <keyword ref="chapter24.html#dimension - angular">dimension - angular</keyword>
      </section>
      <section ref="chapter24.html#7" title="24.7. Leaders">
        <keyword ref="chapter24.html#leader">leader</keyword>
        <keyword ref="chapter24.html#dimension - leader">dimension - leader</keyword>
        <keyword ref="chapter24.html#arrow">arrow</keyword>
        <keyword ref="chapter24.html#pointer">pointer</keyword>
      </section>
    </section>
    <section ref="chapter25.html" title="25. Hatches And Solid Fills"/>
    <section ref="chapter26.html" title="26. Images"/>
    <section ref="chapter27.html" title="27. Selection">
      <section ref="chapter27.html#1" title="27.1. Deselecting All">
        <keyword ref="chapter27.html#deselecting all">deselecting all</keyword>
        <keyword ref="chapter27.html#select - deselect all">select - deselect all</keyword>
      </section>
      <section ref="chapter27.html#2" title="27.2. Selecting All">
        <keyword ref="chapter27.html#selecting all">selecting all</keyword>
        <keyword ref="chapter27.html#select - select all">select - select all</keyword>
      </section>
      <section ref="chapter27.html#3" title="27.3. Selecting Single Entities">
        <keyword ref="chapter27.html#selecting single entities">selecting single entities</keyword>
        <keyword ref="chapter27.html#select - select&#10;    entity">select - select
    entity</keyword>
      </section>
      <section ref="chapter27.html#4" title="27.4. Selecting Contours">
        <keyword ref="chapter27.html#selecting contours">selecting contours</keyword>
        <keyword ref="chapter27.html#select - contour">select - contour</keyword>
        <keyword ref="chapter27.html#deselect -&#10;    contour">deselect -
    contour</keyword>
      </section>
      <section ref="chapter27.html#5" title="27.5. Window Deselection">
        <keyword ref="chapter27.html#window deselection">window deselection</keyword>
        <keyword ref="chapter27.html#deselecting window">deselecting window</keyword>
        <keyword ref="chapter27.html#deselecting&#10;    range">deselecting
    range</keyword>
        <keyword ref="chapter27.html#deselecting area">deselecting area</keyword>
        <keyword ref="chapter27.html#deselecting rectangle">deselecting rectangle</keyword>
      </section>
      <section ref="chapter27.html#6" title="27.6. Window Selection">
        <keyword ref="chapter27.html#window selection">window selection</keyword>
        <keyword ref="chapter27.html#selecting window">selecting window</keyword>
        <keyword ref="chapter27.html#selecting range">selecting range</keyword>
        <keyword ref="chapter27.html#selecting&#10;    area">selecting
    area</keyword>
        <keyword ref="chapter27.html#selecting rectangle">selecting rectangle</keyword>
      </section>
      <section ref="chapter27.html#7" title="27.7. Inverting Selection">
        <keyword ref="chapter27.html#inverting selection">inverting selection</keyword>
        <keyword ref="chapter27.html#select - invert selection">select - invert selection</keyword>
      </section>
      <section ref="chapter27.html#8" title="27.8. Deselect Intersected Entities">
        <keyword ref="chapter27.html#deselect intersected entities">deselect intersected entities</keyword>
      </section>
      <section ref="chapter27.html#9" title="27.9. Select Intersected Entities">
        <keyword ref="chapter27.html#select intersected entities">select intersected entities</keyword>
      </section>
      <section ref="chapter27.html#10" title="27.10. Selecting Layers">
        <keyword ref="chapter27.html#selecting layers">selecting layers</keyword>
        <keyword ref="chapter27.html#select - layer">select - layer</keyword>
        <keyword ref="chapter27.html#deselect -&#10;    layer">deselect -
    layer</keyword>
      </section>
    </section>
    <section ref="chapter28.html" title="28. Modification">
      <section ref="chapter28.html#1" title="28.1. Move / Copy">
        <keyword ref="chapter28.html#move">move</keyword>
        <keyword ref="chapter28.html#modify - move">modify - move</keyword>
        <keyword ref="chapter28.html#translate">translate</keyword>
        <keyword ref="chapter28.html#copy">copy</keyword>
      </section>
      <section ref="chapter28.html#2" title="28.2. Rotate">
        <keyword ref="chapter28.html#rotate">rotate</keyword>
        <keyword ref="chapter28.html#modify - rotate">modify - rotate</keyword>
      </section>
      <section ref="chapter28.html#3" title="28.3. Scale">
        <keyword ref="chapter28.html#scale">scale</keyword>
        <keyword ref="chapter28.html#modify - scale">modify - scale</keyword>
      </section>
      <section ref="chapter28.html#4" title="28.4. Mirror">
        <keyword ref="chapter28.html#mirror">mirror</keyword>
        <keyword ref="chapter28.html#modify - mirror">modify - mirror</keyword>
      </section>
      <section ref="chapter28.html#5" title="28.5. Move and Rotate">
        <keyword ref="chapter28.html#move and rotate">move and rotate</keyword>
        <keyword ref="chapter28.html#modify - move and rotate">modify - move and rotate</keyword>
      </section>
      <section ref="chapter28.html#6" title="28.6. Rotate and Counter-rotate (Rotate Two)">
        <keyword ref="chapter28.html#rotate and counter-rotate">rotate and counter-rotate</keyword>
        <keyword ref="chapter28.html#modify - rotate 2">modify - rotate 2</keyword>
      </section>
      <section ref="chapter28.html#7" title="28.7. Trim / Extend">
        <keyword ref="chapter28.html#trim">trim</keyword>
        <keyword ref="chapter28.html#extend">extend</keyword>
        <keyword ref="chapter28.html#modify - trim">modify - trim</keyword>
      </section>
      <section ref="chapter28.html#8" title="28.8. Trim Two Entities">
        <keyword ref="chapter28.html#trim">trim</keyword>
        <keyword ref="chapter28.html#extend">extend</keyword>
        <keyword ref="chapter28.html#modify - trim two">modify - trim two</keyword>
      </section>
      <section ref="chapter28.html#9" title="28.9. Lengthen">
        <keyword ref="chapter28.html#lengthen">lengthen</keyword>
        <keyword ref="chapter28.html#shorten">shorten</keyword>
        <keyword ref="chapter28.html#modify - lengthen">modify - lengthen</keyword>
      </section>
      <section ref="chapter28.html#10" title="28.10. Stretch">
        <keyword ref="chapter28.html#stretch">stretch</keyword>
        <keyword ref="chapter28.html#modify - stretch">modify - stretch</keyword>
      </section>
      <section ref="chapter28.html#11" title="28.11. Bevel">
        <keyword ref="chapter28.html#bevel">bevel</keyword>
        <keyword ref="chapter28.html#chamfer">chamfer</keyword>
        <keyword ref="chapter28.html#modify - bevel">modify - bevel</keyword>
      </section>
      <section ref="chapter28.html#12" title="28.12. Round">
        <keyword ref="chapter28.html#round">round</keyword>
        <keyword ref="chapter28.html#fillet">fillet</keyword>
        <keyword ref="chapter28.html#modify - round">modify - round</keyword>
      </section>
      <section ref="chapter28.html#13" title="28.13. Divide">
        <keyword ref="chapter28.html#divide">divide</keyword>
        <keyword ref="chapter28.html#cut">cut</keyword>
        <keyword ref="chapter28.html#scissors">scissors</keyword>
        <keyword ref="chapter28.html#modify - divide">modify - divide</keyword>
      </section>
      <section ref="chapter28.html#14" title="28.14. Divide Two">
        <keyword ref="chapter28.html#divide two">divide two</keyword>
        <keyword ref="chapter28.html#cut">cut</keyword>
        <keyword ref="chapter28.html#scissors">scissors</keyword>
        <keyword ref="chapter28.html#modify - divide 2">modify - divide 2</keyword>
      </section>
      <section ref="chapter28.html#15" title="28.15. Properties">
        <keyword ref="chapter28.html#properties">properties</keyword>
        <keyword ref="chapter28.html#modify - properties">modify - properties</keyword>
        <keyword ref="chapter28.html#entity&#10;    properties">entity
    properties</keyword>
      </section>
      <section ref="chapter28.html#16" title="28.16. Attributes">
        <keyword ref="chapter28.html#attributes">attributes</keyword>
        <keyword ref="chapter28.html#modify - attributes">modify - attributes</keyword>
      </section>
      <section ref="chapter28.html#17" title="28.17. Deleting Entities">
        <keyword ref="chapter28.html#delete">delete</keyword>
        <keyword ref="chapter28.html#remove">remove</keyword>
        <keyword ref="chapter28.html#modify - delete">modify - delete</keyword>
      </section>
      <section ref="chapter28.html#18" title="28.18. Exploding Groups">
        <keyword ref="chapter28.html#explode">explode</keyword>
        <keyword ref="chapter28.html#modify - explode">modify - explode</keyword>
      </section>
      <section ref="chapter28.html#19" title="28.19. Explode Text into Letters">
        <keyword ref="chapter28.html#break text">break text</keyword>
        <keyword ref="chapter28.html#modify - break text">modify - break text</keyword>
      </section>
      <section ref="chapter28.html#20" title="28.20. Editing Text">
        <keyword ref="chapter28.html#edit text">edit text</keyword>
        <keyword ref="chapter28.html#modify text">modify text</keyword>
        <keyword ref="chapter28.html#text editing">text editing</keyword>
      </section>
      <section ref="chapter28.html#21" title="28.21. Move to Foreground / Background">
        <keyword ref="chapter28.html#explode">explode</keyword>
        <keyword ref="chapter28.html#modify - explode">modify - explode</keyword>
      </section>
    </section>
    <section ref="chapter29.html" title="29. Isometric Projections"/>
    <section ref="chapter30.html" title="30. Information">
      <section ref="chapter30.html#1" title="30.1. Distance (Point, Point)">
        <keyword ref="chapter30.html#measure distance">measure distance</keyword>
        <keyword ref="chapter30.html#distance">distance</keyword>
      </section>
      <section ref="chapter30.html#2" title="30.2. Distance (Entity, Point)">
        <keyword ref="chapter30.html#measure distance">measure distance</keyword>
        <keyword ref="chapter30.html#distance">distance</keyword>
      </section>
      <section ref="chapter30.html#3" title="30.3. Angle">
        <keyword ref="chapter30.html#measure angle">measure angle</keyword>
        <keyword ref="chapter30.html#angle">angle</keyword>
      </section>
      <section ref="chapter30.html#4" title="30.4. Total Length of Selected Entities">
        <keyword ref="chapter30.html#measure length">measure length</keyword>
        <keyword ref="chapter30.html#total length">total length</keyword>
      </section>
      <section ref="chapter30.html#5" title="30.5. Area">
        <keyword ref="chapter30.html#measure area">measure area</keyword>
        <keyword ref="chapter30.html#area">area</keyword>
      </section>
    </section>
    <section ref="chapter31.html" title="31. Part Library">
      <section ref="chapter31.html#1" title="31.1. Inserting Parts"/>
      <section ref="chapter31.html#2" title="31.2. Extending the Lirary"/>
    </section>
    <section ref="chapter32.html" title="32. Application Preferences">
      <section ref="chapter32.html#1" title="32.1. Appearance">
        <keyword ref="chapter32.html#language">language</keyword>
        <keyword ref="chapter32.html#cursor">cursor</keyword>
        <keyword ref="chapter32.html#crosshairs">crosshairs</keyword>
        <keyword ref="chapter32.html#preview">preview</keyword>
        <keyword ref="chapter32.html#grid spacing">grid spacing</keyword>
      </section>
      <section ref="chapter32.html#2" title="32.2. Paths">
        <keyword ref="chapter32.html#paths">paths</keyword>
      </section>
    </section>
    <section ref="chapter33.html" title="33. Drawing Preferences">
      <section ref="chapter33.html#1" title="33.1. Paper"/>
      <section ref="chapter33.html#2" title="33.2. Units"/>
      <section ref="chapter33.html#3" title="33.3. Grid"/>
      <section ref="chapter33.html#4" title="33.4. Dimensions"/>
      <section ref="chapter33.html#5" title="33.5. Splines"/>
    </section>
    <section ref="chapter34.html" title="34. Appendix"/>
    <section ref="chapter35.html" title="35. Hotkeys">
      <section ref="chapter35.html#1" title="35.1. Command Line">
        <keyword ref="chapter35.html#command line - hotkeys">command line - hotkeys</keyword>
      </section>
      <section ref="chapter35.html#2" title="35.2. File Handling">
        <keyword ref="chapter35.html#file handling - hotkeys">file handling - hotkeys</keyword>
      </section>
      <section ref="chapter35.html#3" title="35.3. Basic Editing">
        <keyword ref="chapter35.html#edit - hotkeys">edit - hotkeys</keyword>
      </section>
      <section ref="chapter35.html#4" title="35.4. View">
        <keyword ref="chapter35.html#view - hotkeys">view - hotkeys</keyword>
      </section>
      <section ref="chapter35.html#5" title="35.5. Layer Handling">
        <keyword ref="chapter35.html#layer - hotkeys">layer - hotkeys</keyword>
      </section>
      <section ref="chapter35.html#6" title="35.6. Snapping">
        <keyword ref="chapter35.html#snapping - hotkeys">snapping - hotkeys</keyword>
      </section>
      <section ref="chapter35.html#7" title="35.7. Construction">
        <keyword ref="chapter35.html#construction - hotkeys">construction - hotkeys</keyword>
      </section>
      <section ref="chapter35.html#8" title="35.8. Dimensioning">
        <keyword ref="chapter35.html#dimensioning - hotkeys">dimensioning - hotkeys</keyword>
      </section>
      <section ref="chapter35.html#9" title="35.9. Entity Selection">
        <keyword ref="chapter35.html#selection - hotkeys">selection - hotkeys</keyword>
      </section>
      <section ref="chapter35.html#10" title="35.10. Modification">
        <keyword ref="chapter35.html#modification - hotkeys">modification - hotkeys</keyword>
      </section>
    </section>
    <section ref="chapter36.html" title="36. Fonts"/>
    <section ref="chapter37.html" title="37. Patterns"/>
    <section ref="chapter38.html" title="38. Mathematical Expressions">
      <section ref="chapter38.html#1" title="38.1. Constants"/>
      <section ref="chapter38.html#2" title="38.2. Functions"/>
    </section>
    <section ref="chapter39.html" title="39. Drawing Units">
      <section ref="chapter39.html#1" title="39.1. Length"/>
      <section ref="chapter39.html#2" title="39.2. Length Display"/>
      <section ref="chapter39.html#3" title="39.3. Angle"/>
      <section ref="chapter39.html#4" title="39.4. Angle Display"/>
    </section>
    <section ref="chapter40.html" title="40. Supported Paper Formats">
      <section ref="chapter40.html#1" title="40.1. Metric"/>
      <section ref="chapter40.html#2" title="40.2. Other"/>
    </section>
    <section ref="chapter41.html" title="41. Migration from QCad 1">
      <section ref="chapter41.html#1" title="41.1. DXF Compatibility"/>
      <section ref="chapter41.html#2" title="41.2. Layer Handling"/>
    </section>
    <section ref="chapter42.html" title="42. Bibliography"/>
  </DCF>
</assistantconfig>